﻿var defaultCheckBoxImage;
var alternateCheckBoxImage;

$(document).on("pageinit", function () {
    $(".numericRanking input.numericAnswer").each(function () {
        checkRankingCount($(this));
    });

    $(".numericRanking input.numericAnswer").on("blur", function (e) {
        checkRankingCount($(this));
    });

    $(document).on("keydown", ".numericRanking input.numericAnswer", function (event) {
        ValidateNumberKeyCode(event, false);
    });

    $(document).on("keyup", ".numericRanking input.numericAnswer", function (event) {
        checkRankingValueBounds($(this));
    });
});

$(document).on("pageshow", function () {
    $("[data-questiontype='numericranking']").each(function () {
        adjustTextWidth($(this));
    });
});

function adjustTextWidth(control) {
    var textWidth = 0;

    if ($(".numericRanking", control).hasClass("left")) {
        $(".numericRanking.left li.rankingItem", control).each(function () {
            var textDiv = $(this).find(".textDiv");

            if (textDiv.width() > textWidth)
                textWidth = textDiv.width();
        });

        if (textWidth > 0)
            $(".numericOptionsList li.rankingItem > .textDiv", control).width(textWidth);
    }
    else {
        var headerWidth = $(".numericRanking li.header", control).find(".textDiv").width();
        var inputDivWidth = $(".numericRanking li.rankingItem", control).find(".inputDiv:first").width();

        if (headerWidth > inputDivWidth)
            $(".numericOptionsList li.rankingItem > .inputDiv", control).width(headerWidth + 3);
    }
}

function numericRankingValidation() {
    var numericRankingHasErrors = false;

    $(".questionContainer .numericRanking").each(function () {
        var numericRanking = $(this);
        var qValues = [];
        var foundDup = false;

        $(".errorMessageContainer", numericRanking.closest(".questionContainer")).remove();
        var nbInputs = $("input:visible", numericRanking).length;

        var maxAnswers = numericRanking.attr("data-maxanswers");
        if (typeof maxAnswers == 'undefined')
            maxAnswers = nbInputs;

        $("input:visible", numericRanking).each(function () {
            var value = parseInt($(this).val().trim(), 10);

            if (value && !foundDup && _.contains(qValues, value)) {
                numericRankingHasErrors = foundDup = true;
                numericRanking.parent().after("<div class='errorMessageContainer'><div class='errorMessage' role='alert'>" + numericRanking.attr("data-client-validation").replace("{max}", maxAnswers) + "</div></div>")
            }
            else if (value && !foundDup) {
                qValues.push(value);
            }
        });

        if (!foundDup && qValues.length > 0) {
            var allowedSum = (qValues.length * (qValues.length + 1)) / 2;
            var sum = _.reduce(qValues, function (memorizer, number) { return memorizer + number; });

            if (allowedSum < sum) {
                numericRankingHasErrors = true;
                numericRanking.parent().after("<div class='errorMessageContainer'><div class='errorMessage' role='alert'>" + numericRanking.attr("data-client-validation").replace("{max}", maxAnswers) + "</div></div>")
            }
        }
    });

    return !numericRankingHasErrors;
}

function checkRankingValueBounds(element) {
    var choiceList = element.closest(".numericRanking");
    var maxAnswers = choiceList.attr("data-maxanswers");
    var boxes = $("input.numericAnswer", choiceList);
    var value = element.val() ? parseInt(element.val(), 10) : null;
    var maxValue = maxAnswers ? parseInt(maxAnswers, 10) : boxes.length;

    if ((value && (value <= 0 || maxValue < value)) || value == "0") {
        element.val("");
        return false;
    }
}

function checkRankingCount(element) {
    var choiceList = element.closest(".numericRanking");
    var maxAnswers = choiceList.attr("data-maxanswers");
    var boxes = $("input.numericAnswer", choiceList);

    if (maxAnswers) {
        var answered = boxes.filter(function() { return $(this).val().trim() != ''; }).length;

        if (answered == parseInt(maxAnswers)) {
            boxes.filter(function () { return $(this).val().trim() == ''; }).prop("disabled", true);
            boxes.closest("li.rankingItem").addClass("maxDisabled");
        }
        else {
            boxes.prop("disabled", false);
            boxes.closest("li.rankingItem").removeClass("maxDisabled");
        }
    }
}